import { EmitableEvent, EventEmitter } from '../common/eventEmitter';
interface BaseNode {
    node: AudioNode;
    channel?: number;
}
interface AudioPlayerEvent extends EmitableEvent {
    play: (node: AudioBufferSourceNode) => void;
    update: (audio: AudioBuffer) => void;
    end: (node: AudioBufferSourceNode) => void;
}
export type AudioParamOf<T> = Record<SelectKey<T, AudioParam>, number>;
export declare class AudioPlayer extends EventEmitter<AudioPlayerEvent> {
    static ac: AudioContext;
    static index: number;
    /** 音频的索引，这样的话可以复用来提高性能表现 */
    index: number;
    data: ArrayBuffer;
    buffer: AudioBuffer | null;
    source?: AudioBufferSourceNode;
    baseNode: BaseNode[];
    constructor(data: ArrayBuffer);
    /**
     * 更新音频数据
     * @param data 音频的ArrayBuffer数据
     */
    update(data: ArrayBuffer): Promise<void>;
    /**
     * 获取音频源数据节点
     */
    getSource(): AudioBufferSourceNode;
    /**
     * 播放音频
     */
    play(when?: number, offset?: number, duration?: number): AudioBufferSourceNode | undefined;
    /**
     * 准备音频资源连接
     */
    ready(): void;
    /**
     * 获取音频输出destination
     */
    getDestination(): AudioDestinationNode;
}
export {};
